module My_RPG


  class My_Troop < RPG::Troop

    include My_DB_Text
    

    attr_accessor :numero

    def to_rmxp
      
      rmxp = self.cast(RPG::Troop)
      for i in 0...rmxp.pages.size
        rmxp.pages[i] = rmxp.pages[i].to_rmxp
      end

      for i in 0...rmxp.members.size
        rmxp.members[i] = rmxp.members[i].to_rmxp
      end


      return rmxp

    end

    def changer_lignes!
      for page in @pages
        page.changer_lignes!
      end
    end


    def exporter_dialogue

      txt = ""
      i = 0
      for i in 0...@pages.size
        txt << @pages[i].exporter_dialogue
      end

      return txt if txt == ""
      lignes = "\n"*2
      max = MAX_CARAC
      lignes << CARAC_EVENT * max + "\n"
      lignes << "TROOP #{@numero+1}" + "\n"
      lignes << CARAC_FIN * max + "\n"
      #lignes << "\n"
      lignes << txt
      lignes << "\n"
      
      return lignes
    end

    def classe
      return "Troop"
    end



    def remplacer_texte(num_page, pos, message)

      page = @pages[num_page]
      if page == nil
        position = "#{self.classe}:#{self.numero}:#{num_page}"
        message.force_encoding("UTF-8")
        raise(DMKW_Message_Replace_Pos.new(position, message))
        return true
      end
      res = page.remplacer_texte(pos, message)

      return res
    end

  end


end
